#pragma once

class CVertexBufferObject
{
private:
	UINT uiBuffer;
	int iSize;
	int iBufferType;
	vector<BYTE> data;
	bool bDataUploaded;

public:
	CVertexBufferObject();

	UINT getBuffer();

	void createVBO(int a_iSize = 0);
	void releaseVBO();
	void* mapBufferToMemory(int iUsageHint);
	void* mapSubBufferToMemory(int iUsageHint, UINT uiOffset, UINT uiLength);
	void unmapBuffer();
	void bindVBO(int a_iBufferType = GL_ARRAY_BUFFER);
	void uploadDataToGPU(int iUsageHint);
	void addData(void* ptrData, UINT uiDataSize);
	void* getDataPointer();
};
